tinymce.PluginManager.add('pts_tooltip', function(editor) {

    function getHtmlPanel() {
        var $newEl = jQuery('#ptsMceSubMenyAddTooltip');
        $newMainEl = $newEl.clone().removeAttr('id');
        return $newMainEl[0].outerHTML;
    }

    editor.addButton('pts_tooltip', {
        type: 'panelbutton'
        ,	icon: 'info'
        ,	tooltip: 'Edit tooltip'
        ,	onclick: function(e) {}
        ,	stateSelector: 'a[href]'

        ,	panel: {
            role: 'application'
            ,	html: getHtmlPanel
            ,   isHasEvent: false
            ,	border: 1	// All other menus have border: 1 by default, this should look like same
            ,	onshow: function (e) {
                var control = jQuery('#' + e.control._id),
                    $divElem = jQuery(editor.bodyElement).closest('div.ptsCell, div.ptsColFooter, div.ptsColDesc, div.ptsColHeader'),
                    $tooltipInp = control.find('label.ptsElMenuSubPanelRow[data-id=tooltip] input');
                    
                    $tooltipInp.val($divElem.attr('title'));
                    $tooltipInp.change(function(){
                        var value = jQuery(this).val();
                        if(value.length) {
                            $divElem.attr('title', value);
                        } else {
                            $divElem.removeAttr('title');
                        }
                    });

            }
            ,	onhide: function(e) {}
        }
    });
});